# Plugin SEO Panel con IA para WordPress

Plugin de WordPress que se conecta con el Panel SEO con IA para analizar y mejorar automáticamente el SEO de tus páginas y posts.

## Características

- ✅ Análisis automático de SEO usando IA
- ✅ Sistema de suscripciones con planes
- ✅ Integración completa con WordPress
- ✅ API segura con autenticación por API keys
- ✅ Dashboard intuitivo en el admin de WordPress
- ✅ Historial de análisis

## Instalación

1. Sube la carpeta `seo-panel-wp-plugin` a `/wp-content/plugins/`
2. Activa el plugin desde el panel de WordPress
3. Ve a **SEO Panel IA > Configuración** y configura tu API Key
4. Activa tu suscripción en **SEO Panel IA > Suscripción**

## Configuración

### Obtener API Key

1. Accede a https://seo.ambertrack.shop
2. Ve a la sección de API Keys (o contacta al administrador)
3. Genera una nueva API Key
4. Copia la API Key y pégala en la configuración del plugin

### Activar Suscripción

1. Ve a **SEO Panel IA > Suscripción**
2. Selecciona tu plan:
   - **Básico**: $29/mes - 50 análisis/mes
   - **Pro**: $79/mes - 200 análisis/mes
   - **Enterprise**: $199/mes - Ilimitado
3. Ingresa tu API Key
4. Selecciona la duración
5. Haz clic en "Activar Suscripción"

## Uso

### Analizar una Página/Post

1. Ve a **SEO Panel IA > Dashboard**
2. Ingresa la URL completa o el ID del post
3. (Opcional) Agrega información sobre el contenido
4. Haz clic en "Analizar SEO"
5. Revisa los resultados y aplica las mejoras sugeridas

## Planes de Suscripción

### Básico - $29/mes
- 50 análisis por mes
- Soporte por email
- Análisis básico de SEO
- Mejoras automáticas

### Pro - $79/mes
- 200 análisis por mes
- Soporte prioritario
- Análisis avanzado
- API access
- Historial completo

### Enterprise - $199/mes
- Análisis ilimitados
- Soporte 24/7
- Análisis completo
- API ilimitada
- White label
- Personalización

## API

El plugin se comunica con el Panel SEO a través de una API REST segura:

- `POST /api/analyze` - Analizar sitio web
- `POST /api/analyze_file` - Analizar archivo específico
- `POST /api/apply_seo` - Aplicar mejoras SEO
- `GET /api/verify` - Verificar API key

Todas las peticiones requieren un header `X-API-Key` con tu API key.

## Soporte

Para soporte técnico o preguntas sobre suscripciones:
- Email: soporte@ambertrack.shop
- Panel: https://seo.ambertrack.shop

## Changelog

### 1.0.0
- Versión inicial
- Sistema de suscripciones
- Integración con Panel SEO
- Dashboard de administración
