<?php
/**
 * Clase para el panel de administración
 */

if (!defined('ABSPATH')) {
    exit;
}

class SEO_Panel_Admin {
    
    public function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_init', array($this, 'register_settings'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
    }
    
    public function add_admin_menu() {
        add_menu_page(
            'SEO Panel IA',
            'SEO Panel IA',
            'manage_options',
            'seo-panel-ia',
            array($this, 'render_dashboard'),
            'dashicons-chart-line',
            30
        );
        
        add_submenu_page(
            'seo-panel-ia',
            'Dashboard',
            'Dashboard',
            'manage_options',
            'seo-panel-ia',
            array($this, 'render_dashboard')
        );
        
        add_submenu_page(
            'seo-panel-ia',
            'Suscripción',
            'Suscripción',
            'manage_options',
            'seo-panel-subscription',
            array($this, 'render_subscription')
        );
        
        add_submenu_page(
            'seo-panel-ia',
            'Configuración',
            'Configuración',
            'manage_options',
            'seo-panel-settings',
            array($this, 'render_settings')
        );
    }
    
    public function register_settings() {
        register_setting('seo_panel_settings', 'seo_panel_api_key');
    }
    
    public function enqueue_scripts($hook) {
        if (strpos($hook, 'seo-panel') === false) {
            return;
        }
        
        wp_enqueue_style('seo-panel-admin', SEO_PANEL_PLUGIN_URL . 'assets/admin.css');
        wp_enqueue_script('seo-panel-admin', SEO_PANEL_PLUGIN_URL . 'assets/admin.js', array('jquery'), SEO_PANEL_VERSION, true);
        
        wp_localize_script('seo-panel-admin', 'seoPanel', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('seo_panel_nonce')
        ));
    }
    
    public function render_dashboard() {
        $subscription = new SEO_Panel_Subscription();
        $subscription_info = $subscription->get_info();
        $api = new SEO_Panel_API();
        
        include SEO_PANEL_PLUGIN_DIR . 'admin/views/dashboard.php';
    }
    
    public function render_subscription() {
        $subscription = new SEO_Panel_Subscription();
        $subscription_info = $subscription->get_info();
        
        // Procesar activación de suscripción
        if (isset($_POST['activate_subscription']) && check_admin_referer('seo_panel_subscription')) {
            $plan = sanitize_text_field($_POST['plan']);
            $api_key = sanitize_text_field($_POST['api_key']);
            $duration = intval($_POST['duration']);
            
            if ($subscription->activate($plan, $duration, $api_key)) {
                echo '<div class="notice notice-success"><p>Suscripción activada correctamente.</p></div>';
            }
        }
        
        include SEO_PANEL_PLUGIN_DIR . 'admin/views/subscription.php';
    }
    
    public function render_settings() {
        if (isset($_POST['save_settings']) && check_admin_referer('seo_panel_settings')) {
            update_option('seo_panel_api_key', sanitize_text_field($_POST['api_key']));
            echo '<div class="notice notice-success"><p>Configuración guardada.</p></div>';
        }
        
        include SEO_PANEL_PLUGIN_DIR . 'admin/views/settings.php';
    }
}
