<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap seo-panel-dashboard">
    <h1>SEO Panel con IA - Dashboard</h1>
    
    <?php if (!$subscription_info['is_active']): ?>
        <div class="notice notice-warning">
            <p><strong>Suscripción inactiva.</strong> <a href="<?php echo admin_url('admin.php?page=seo-panel-subscription'); ?>">Activa tu suscripción</a> para usar el servicio.</p>
        </div>
    <?php else: ?>
        <div class="notice notice-success">
            <p><strong>Suscripción activa</strong> - Plan: <?php echo esc_html($subscription_info['plan']); ?> 
            <?php if ($subscription_info['expires']): ?>
                - Expira: <?php echo esc_html($subscription_info['expires']); ?>
            <?php endif; ?>
            </p>
        </div>
    <?php endif; ?>
    
    <div class="seo-panel-widgets">
        <div class="widget">
            <h2>Analizar Página/Post</h2>
            <form id="analyze-form">
                <p>
                    <label>URL o ID del Post:</label><br>
                    <input type="text" id="analyze-url" class="regular-text" placeholder="https://tusitio.com/pagina o 123">
                </p>
                <p>
                    <label>Información adicional (opcional):</label><br>
                    <textarea id="analyze-info" class="large-text" rows="3" placeholder="Describe el contenido..."></textarea>
                </p>
                <p>
                    <button type="submit" class="button button-primary">Analizar SEO</button>
                </p>
            </form>
            <div id="analyze-results" style="display:none; margin-top: 20px;"></div>
        </div>
        
        <div class="widget">
            <h2>Análisis Recientes</h2>
            <div id="recent-analyses">
                <p>Cargando...</p>
            </div>
        </div>
    </div>
</div>

<style>
.seo-panel-dashboard .widget {
    background: #fff;
    padding: 20px;
    margin: 20px 0;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}
.seo-panel-dashboard .widget h2 {
    margin-top: 0;
}
</style>

<script>
jQuery(document).ready(function($) {
    console.log('SEO Panel Dashboard cargado');
    console.log('AJAX URL:', typeof seoPanel !== 'undefined' ? seoPanel.ajax_url : 'NO DEFINIDO');
    
    $('#analyze-form').on('submit', function(e) {
        e.preventDefault();
        
        var url = $('#analyze-url').val();
        var info = $('#analyze-info').val();
        
        if (!url) {
            alert('Por favor, ingresa una URL o ID de post');
            return;
        }
        
        // Mostrar loading
        var $button = $(this).find('button[type="submit"]');
        var originalText = $button.text();
        $button.prop('disabled', true).text('Analizando...');
        $('#analyze-results').html('<p style="padding: 20px; background: #f0f0f0; border-radius: 5px;">⏳ Analizando, por favor espera...</p>').show();
        
        if (typeof seoPanel === 'undefined') {
            alert('Error: Configuración del plugin no encontrada. Recarga la página.');
            $button.prop('disabled', false).text(originalText);
            return;
        }
        
        console.log('Enviando solicitud de análisis...', {url: url, info: info});
        
        $.ajax({
            url: seoPanel.ajax_url,
            type: 'POST',
            data: {
                action: 'seo_panel_analyze',
                url: url,
                info: info,
                nonce: seoPanel.nonce
            },
            timeout: 95000, // 95 segundos
            success: function(response) {
                console.log('Respuesta recibida:', response);
                $button.prop('disabled', false).text(originalText);
                
                if (response.success) {
                    $('#analyze-results').html(response.data.html).show();
                } else {
                    var errorMsg = response.data && response.data.message ? response.data.message : 'Error desconocido';
                    $('#analyze-results').html('<div style="padding: 20px; background: #fee; border: 1px solid #fcc; border-radius: 5px; color: #c00;"><strong>Error:</strong> ' + errorMsg + '</div>').show();
                    alert('Error: ' + errorMsg);
                }
            },
            error: function(xhr, status, error) {
                console.error('Error AJAX:', {xhr: xhr, status: status, error: error});
                $button.prop('disabled', false).text(originalText);
                
                var errorMsg = 'Error de conexión';
                if (status === 'timeout') {
                    errorMsg = 'La solicitud tardó demasiado tiempo. Intenta con una URL más rápida o verifica tu conexión.';
                } else if (xhr.responseJSON && xhr.responseJSON.data && xhr.responseJSON.data.message) {
                    errorMsg = xhr.responseJSON.data.message;
                } else if (error) {
                    errorMsg = error;
                }
                
                $('#analyze-results').html('<div style="padding: 20px; background: #fee; border: 1px solid #fcc; border-radius: 5px; color: #c00;"><strong>Error:</strong> ' + errorMsg + '</div>').show();
                alert('Error: ' + errorMsg);
            }
        });
    });
});
</script>
