<?php
if (!defined('ABSPATH')) exit;

$api_key = get_option('seo_panel_api_key', '');
?>

<div class="wrap">
    <h1>Configuración - SEO Panel IA</h1>
    
    <form method="post">
        <?php wp_nonce_field('seo_panel_settings'); ?>
        <table class="form-table">
            <tr>
                <th><label for="api_key">API Key</label></th>
                <td>
                    <input type="text" id="api_key" name="api_key" 
                           value="<?php echo esc_attr($api_key); ?>" 
                           class="regular-text" required>
                    <p class="description">
                        Obtén tu API Key desde el panel de SEO en 
                        <a href="https://seo.ambertrack.shop" target="_blank">seo.ambertrack.shop</a>
                    </p>
                </td>
            </tr>
        </table>
        
        <p class="submit">
            <button type="submit" name="save_settings" class="button button-primary">
                Guardar Configuración
            </button>
        </p>
    </form>
    
    <?php if ($api_key): ?>
        <div class="card" style="margin-top: 20px;">
            <h2>Estado de Conexión</h2>
            <button type="button" id="verify-key" class="button button-primary">🔍 Verificar Conexión</button>
            <div id="verify-result" style="margin-top: 15px; padding: 15px; border-radius: 5px; display: none;"></div>
        </div>
        
        <script>
        jQuery(document).ready(function($) {
            $('#verify-key').on('click', function() {
                var $button = $(this);
                var $result = $('#verify-result');
                
                $button.prop('disabled', true).text('Verificando...');
                $result.hide();
                
                $.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    type: 'POST',
                    data: {
                        action: 'seo_panel_verify_key',
                        nonce: '<?php echo wp_create_nonce('seo_panel_nonce'); ?>'
                    },
                    success: function(response) {
                        $button.prop('disabled', false).text('🔍 Verificar Conexión');
                        
                        if (response.success && response.data.valid) {
                            var html = '<div style="background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 15px; border-radius: 5px;">';
                            html += '<h3 style="margin: 0 0 10px 0; color: #155724;">✓ Conexión Exitosa</h3>';
                            html += '<p style="margin: 5px 0;"><strong>Usuario:</strong> ' + (response.data.user || 'N/A') + '</p>';
                            html += '<p style="margin: 5px 0;"><strong>Plan:</strong> ' + (response.data.plan || 'N/A') + '</p>';
                            html += '<p style="margin: 5px 0;"><strong>Estado:</strong> <span style="color: #28a745; font-weight: bold;">🟢 Conectado</span></p>';
                            html += '<p style="margin: 5px 0; font-size: 12px; color: #6c757d;">' + (response.data.message || 'Conexión verificada correctamente') + '</p>';
                            html += '</div>';
                            $result.html(html).show();
                        } else {
                            var html = '<div style="background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 15px; border-radius: 5px;">';
                            html += '<h3 style="margin: 0 0 10px 0; color: #721c24;">✗ Error de Conexión</h3>';
                            html += '<p style="margin: 5px 0;">' + (response.data.message || 'No se pudo verificar la conexión') + '</p>';
                            html += '<p style="margin: 5px 0; font-size: 12px;">Verifica que la API Key sea correcta y que el servidor esté accesible.</p>';
                            html += '</div>';
                            $result.html(html).show();
                        }
                    },
                    error: function() {
                        $button.prop('disabled', false).text('🔍 Verificar Conexión');
                        var html = '<div style="background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 15px; border-radius: 5px;">';
                        html += '<h3 style="margin: 0 0 10px 0; color: #721c24;">✗ Error de Conexión</h3>';
                        html += '<p>No se pudo conectar con el servidor. Verifica tu conexión a internet.</p>';
                        html += '</div>';
                        $result.html(html).show();
                    }
                });
            });
        });
        </script>
    <?php endif; ?>
</div>
