<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap">
    <h1>Suscripción - SEO Panel IA</h1>
    
    <?php if ($subscription_info['is_active']): ?>
        <div class="card">
            <h2>Estado de Suscripción</h2>
            <p><strong>Plan:</strong> <?php echo esc_html($subscription_info['plan']); ?></p>
            <p><strong>Estado:</strong> <span style="color: green;">Activa</span></p>
            <?php if ($subscription_info['expires']): ?>
                <p><strong>Expira:</strong> <?php echo esc_html($subscription_info['expires']); ?></p>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="card">
            <h2>Activar Suscripción</h2>
            <form method="post">
                <?php wp_nonce_field('seo_panel_subscription'); ?>
                <table class="form-table">
                    <tr>
                        <th><label>Plan</label></th>
                        <td>
                            <select name="plan" required>
                                <option value="basic">Básico - $2/mes</option>
                                <option value="pro">Pro - $3/mes</option>
                                <option value="enterprise">Enterprise - $5/mes</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th><label>Duración (días)</label></th>
                        <td>
                            <input type="number" name="duration" value="30" min="1" required>
                        </td>
                    </tr>
                    <tr>
                        <th><label>API Key</label></th>
                        <td>
                            <input type="text" name="api_key" class="regular-text" 
                                   value="<?php echo esc_attr(get_option('seo_panel_api_key', '')); ?>" required>
                            <p class="description">Obtén tu API Key desde el panel de SEO</p>
                        </td>
                    </tr>
                </table>
                <p class="submit">
                    <button type="submit" name="activate_subscription" class="button button-primary">Activar Suscripción</button>
                </p>
            </form>
        </div>
        
        <div class="card" style="margin-top: 20px;">
            <h2>Planes Disponibles</h2>
            <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; margin-top: 20px;">
                <div style="border: 1px solid #ddd; padding: 20px;">
                    <h3>Básico</h3>
                    <p style="font-size: 24px; font-weight: bold;">$2/mes</p>
                    <ul>
                        <li>50 análisis/mes</li>
                        <li>Soporte por email</li>
                        <li>Análisis básico de SEO</li>
                        <li>Palabras clave básicas</li>
                    </ul>
                </div>
                <div style="border: 1px solid #ddd; padding: 20px;">
                    <h3>Pro</h3>
                    <p style="font-size: 24px; font-weight: bold;">$3/mes</p>
                    <ul>
                        <li>200 análisis/mes</li>
                        <li>Soporte prioritario</li>
                        <li>Análisis avanzado</li>
                        <li>API access</li>
                        <li>Palabras clave avanzadas</li>
                    </ul>
                </div>
                <div style="border: 1px solid #ddd; padding: 20px; border-color: #667eea; border-width: 2px;">
                    <h3>Enterprise</h3>
                    <p style="font-size: 24px; font-weight: bold; color: #667eea;">$5/mes</p>
                    <ul>
                        <li>Análisis ilimitados</li>
                        <li>Soporte 24/7</li>
                        <li>Análisis completo</li>
                        <li>API ilimitada</li>
                        <li>JavaScript metadata (JSON-LD)</li>
                        <li>Palabras clave optimizadas</li>
                        <li>White label</li>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
