<?php
/**
 * Clase para manejar suscripciones
 */

if (!defined('ABSPATH')) {
    exit;
}

class SEO_Panel_Subscription {
    
    /**
     * Verificar si la suscripción está activa
     */
    public function is_active() {
        $status = get_option('seo_panel_subscription_status', 'inactive');
        $expires = get_option('seo_panel_subscription_expires', '');
        
        if ($status !== 'active') {
            return false;
        }
        
        // Verificar si ha expirado
        if (!empty($expires)) {
            $expires_timestamp = strtotime($expires);
            if ($expires_timestamp < time()) {
                update_option('seo_panel_subscription_status', 'expired');
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * Activar suscripción
     */
    public function activate($plan, $duration_days = 30, $api_key = '') {
        $expires = date('Y-m-d H:i:s', strtotime("+{$duration_days} days"));
        
        update_option('seo_panel_subscription_status', 'active');
        update_option('seo_panel_subscription_expires', $expires);
        update_option('seo_panel_subscription_plan', $plan);
        
        if (!empty($api_key)) {
            update_option('seo_panel_api_key', $api_key);
        }
        
        // Guardar en base de datos
        global $wpdb;
        $table = $wpdb->prefix . 'seo_panel_subscriptions';
        
        $wpdb->insert(
            $table,
            array(
                'user_id' => get_current_user_id(),
                'plan' => $plan,
                'status' => 'active',
                'api_key' => $api_key ?: get_option('seo_panel_api_key', ''),
                'expires_at' => $expires
            ),
            array('%d', '%s', '%s', '%s', '%s')
        );
        
        return true;
    }
    
    /**
     * Obtener información de la suscripción
     */
    public function get_info() {
        return array(
            'status' => get_option('seo_panel_subscription_status', 'inactive'),
            'plan' => get_option('seo_panel_subscription_plan', ''),
            'expires' => get_option('seo_panel_subscription_expires', ''),
            'is_active' => $this->is_active()
        );
    }
    
    /**
     * Cancelar suscripción
     */
    public function cancel() {
        update_option('seo_panel_subscription_status', 'cancelled');
        
        global $wpdb;
        $table = $wpdb->prefix . 'seo_panel_subscriptions';
        $wpdb->update(
            $table,
            array('status' => 'cancelled'),
            array('user_id' => get_current_user_id(), 'status' => 'active'),
            array('%s'),
            array('%d', '%s')
        );
    }
}
