<?php
/**
 * Plugin Name: SEO Panel con IA
 * Plugin URI: https://seo.ambertrack.shop
 * Description: Plugin para conectar WordPress con el Panel SEO con IA. Analiza y mejora el SEO de tus páginas automáticamente.
 * Version: 1.0.0
 * Author: AmberTrack
 * Author URI: https://ambertrack.shop
 * License: GPL v2 or later
 * Text Domain: seo-panel-ia
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Definir constantes
define('SEO_PANEL_VERSION', '1.0.0');
define('SEO_PANEL_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('SEO_PANEL_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SEO_PANEL_API_URL', 'https://seo.ambertrack.shop'); // URL del panel SEO

// Incluir archivos necesarios
require_once SEO_PANEL_PLUGIN_DIR . 'includes/class-seo-panel-api.php';
require_once SEO_PANEL_PLUGIN_DIR . 'includes/class-seo-panel-subscription.php';
require_once SEO_PANEL_PLUGIN_DIR . 'admin/class-seo-panel-admin.php';
require_once SEO_PANEL_PLUGIN_DIR . 'public/class-seo-panel-public.php';

/**
 * Clase principal del plugin
 */
class SEO_Panel_Plugin {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        $this->init_hooks();
    }
    
    private function init_hooks() {
        // Activar/Desactivar plugin
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
        
        // Inicializar componentes
        add_action('plugins_loaded', array($this, 'init'));
    }
    
    public function activate() {
        // Crear tablas necesarias
        $this->create_tables();
        
        // Crear opciones por defecto
        add_option('seo_panel_api_key', '');
        add_option('seo_panel_subscription_status', 'inactive');
        add_option('seo_panel_subscription_expires', '');
    }
    
    public function deactivate() {
        // Limpiar si es necesario
    }
    
    private function create_tables() {
        global $wpdb;
        
        $charset_collate = $wpdb->get_charset_collate();
        
        // Tabla de suscripciones
        $table_subscriptions = $wpdb->prefix . 'seo_panel_subscriptions';
        $sql_subscriptions = "CREATE TABLE IF NOT EXISTS $table_subscriptions (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            user_id bigint(20) NOT NULL,
            plan varchar(50) NOT NULL,
            status varchar(20) NOT NULL,
            api_key varchar(255) NOT NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            expires_at datetime NULL,
            PRIMARY KEY (id),
            KEY user_id (user_id)
        ) $charset_collate;";
        
        // Tabla de análisis
        $table_analyses = $wpdb->prefix . 'seo_panel_analyses';
        $sql_analyses = "CREATE TABLE IF NOT EXISTS $table_analyses (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            post_id bigint(20) NOT NULL,
            analysis_data longtext,
            seo_score int(11) DEFAULT 0,
            analyzed_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY post_id (post_id)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql_subscriptions);
        dbDelta($sql_analyses);
    }
    
    public function init() {
        // Inicializar admin
        if (is_admin()) {
            new SEO_Panel_Admin();
        }
        
        // Inicializar público
        new SEO_Panel_Public();
    }
}

// Inicializar plugin
SEO_Panel_Plugin::get_instance();
